<?php
require_once('error_handler.php');
require_once('snipear/code/standard'.$G_phpextension);
require_once('snipear/code/additional'.$G_phpextension);
require_once('snipear/code/functions'.$G_phpextension);
require_once('snipear/code/system'.$G_phpextension);
require_once('snipear/code/dataaccess'.$G_phpextension);
require_once('snipear/code/corecode/coredb'.$G_phpextension);
require_once('snipear/code/logging'.$G_phpextension);
require_once('snipear/code/classes/class.tdownload'.$G_phpextension);
require_once('class.tsecuritylayer'.$G_phpextension);
require_once('class.tftmebasepage'.$G_phpextension);
require_once('snipear/code/filefunctions'.$G_phpextension);
require_once('class.tftdb'.$G_phpextension);
require_once('class.tfilestogetherME'.$G_phpextension);

class TDelfolder extends TFTMEBasePage{

  public $filepath='';
  public $hidden='';
  public $TFileList;
  public $maintable;

  function __construct($name='', $boolpersist=false, $needslogon=true){
  	parent::__construct($name, $boolpersist, $needslogon);

  	$this->title='Delete folder';

   	$this->frm_event->value='folder_delete';

    $toplbl=new TLabel('toplbl');
	  $toplbl->proparray['class']='tlabel_header';
    $toplbl->caption=$this->title;

  	$this->titletable->addtocell('1cell1' , $toplbl);

  	//Build filelist  Object
  	$this->TFileList = new TFTMEFileList('_TFileList');
  	$this->TFileList->drivearray = $this->drivearray;

  	$this->hidden=new THidden('folder_to_delete');

    if (!_empty($_GET['contextfolderpath'])){
      //we should check that the user has permission on this folder for security reasons
      $this->hidden->value=fix_foldername( stripslashes($_GET['contextfolderpath']));
    }else
    if (_empty($this->hidden->text)){
     	$sl='';
    	if (!empty($_SESSION['fpath']))
    	  $sl='/';
      $this->hidden->value=$_SESSION['fdrive'].$sl.stripslashes($_SESSION['fpath']);
    }

    $this->addobject($this->hidden);
    $this->filepath=$this->TFileList->get_real_path_from_vpath($this->hidden->value);

    $this->addobject($this->hidden);

    $this->maintable=new TSimpleTable("maintable");
    $this->maintable->proparray['border']='0';
    $this->maintable->proparray['width']='245';
    $this->maintable->proparray['align']='left';
    $this->maintable->cellpadding=5;
    $this->maintable->cellspacing=0;

    //message
    $lbl_ftd = new TLabel('lbl_ftd');
    $lbl_ftd->caption='Folder to delete:';
    $lbl_ftd->proparray['class']='tlabel_new';

    $lbl_filename = new THtmlEdit('lbl_filename');
    $lbl_filename->value=$this->hidden->value;
  	$lbl_filename->width=200;
  	$lbl_filename->disabled=true;
  	$lbl_filename->readonly=true;

  	$this->btn_submit->caption='Delete';
    if (empty($this->drivearray[$this->hidden->value])){
      $this->maintable->addtocell('1cell1' , $lbl_ftd);
    	$this->maintable->addtocell('2cell1' , $lbl_filename);
     	$this->maintable->addtocell('3cell1' , $this->btn_submit);
    }else{
      $err=new TErrorLabel('info');
      $err->caption='errdrivenodel';
     	$this->maintable->addtocell('3cell1' , $err);
    }

  	$this->maintable->addtocell('4cell1' , $this->btn_cancel);

  	$this->maintable->rows = 4;
  	$this->maintable->cols = 1;
    $this->maintable->tdproparray['align']='left';
    $this->headertable->addtocell('2cell1' , $this->maintable);

  }

  function folder_delete($sender){
  	/*
  	NOTE: rmdirr comes from the filefunctions.php file in the sniPEAR framework
  	*/
  	if (rmdirrft($this->filepath)){
  	  $security_layer=new TSecurityLayer('tsecuritylayer', null);
  	  $vdrive=$security_layer->getdefaultpath();

  	  $arr=explode("/", $this->hidden->value);

  	  $parentpath="";

  	  for($i=1;$i<count($arr)-1;$i++){
  	    //$parentpath.="/";
  	    $parentpath.=$arr[$i];
  	  }

  	  $_SESSION['fpath']=$parentpath;

  	  $link="ftme".$this->G_phpextension."?drive=".urlencode($_SESSION['fdrive'])."&path=".urlencode($parentpath);
      OpenPage($link);

  	}else{
  	  $error=new TErrorLabel('error');
  	  $error->caption='errfolderdelfail';//Folder Delete failed. Please contact your system administrator.
    	$this->maintable->rows = 5;
    	$this->maintable->cols = 1;
      $this->maintable->addtocell('5cell1' , $error);
  	}

  }
}

?>
