<?php
require_once('error_handler.php');
require_once('snipear/code/standard'.$G_phpextension);
require_once('snipear/code/additional'.$G_phpextension);
require_once('snipear/code/functions'.$G_phpextension);
require_once('snipear/code/system'.$G_phpextension);
require_once('snipear/code/dataaccess'.$G_phpextension);
require_once('snipear/code/corecode/coredb'.$G_phpextension);
require_once('snipear/code/logging'.$G_phpextension);
require_once('snipear/code/classes/class.tdownload'.$G_phpextension);
require_once('class.tsecuritylayer'.$G_phpextension);
require_once('class.tftmebasepage'.$G_phpextension);
require_once('class.tftdb'.$G_phpextension);
require_once('class._system.tfilestogether_menutypes'.$G_phpextension);

class Tfilemenu extends TFTMEBasePage{

  public $hidden;
  public $vdrive;
  public $TFileList;
  public $lblre;
  public $newnameobj;

  function __construct($name='', $boolpersist=false, $needslogon=true){
  	parent::__construct($name, $boolpersist, $needslogon);

  	$this->title='File Menu Dialog';

  	$this->TFileList = new TFTMEFileList('_TFileList');
  	$this->TFileList->drivearray = $this->drivearray;

  	$this->hidden=new THidden('folder_to_rename');

  	$this->hidden->value =  $_GET['filepath'];
  	$this->addobject($this->hidden);

	  $fpath=$_SESSION['fpath'];
	  if (!empty($fpath))
	    $fpath='/'.$fpath;
    $this->security_layer->folderpath=$_SESSION['fdrive'].$fpath;

    $toplbl=new TLabel('toplbl');
  	$toplbl->proparray['class']='tlabel_header';
    $toplbl->caption='Menu Option';

	  $this->titletable->addtocell('1cell1' , $toplbl);

    $fodlertable=new TSimpleTable("fodlertable");
    $fodlertable->proparray['border']='0';
    $fodlertable->proparray['width']='245';
   	$fodlertable->proparray['align']='left';
    $fodlertable->cellpadding=0;
    $fodlertable->cellspacing=3;

  	$lbl = new TLabel('cFolderpath');
  	$lbl->caption='Current File:';
    $lbl->proparray['class']='tlabel_table_header';
  	$fodlertable->addtocell('1cell1' , $lbl);

  	$lbl_filename = new THtmlEdit('lbl_filename');
  	$fname=fix_foldername(htmlspecialchars($this->hidden->value));
  	$lbl_filename->value=$fname;
  	$lbl_filename->width=200;
  	$lbl_filename->disabled=true;
  	$lbl_filename->readonly=true;
  	$fodlertable->addtocell('2cell1' , $lbl_filename);

  	$lbl_option = new TLabel('cOptions');
  	$lbl_option->caption='Options:';
    $lbl_option->proparray['class']='tlabel_table_header';
  	//$this->addobject($lbl);
  	$fodlertable->addtocell('3cell1' , $lbl_option);

    $linktable=new TSimpleTable("fodlertable1");
    $linktable->proparray['border']='0';
    $linktable->proparray['width']='245';
  	$linktable->proparray['align']='left';
    $linktable->cellpadding=2;
    $linktable->cellspacing=0;

  	$exp_link =  new TLabelImageLink('Download');
  	$exp_link->caption = 'Download';
  	$exp_link->src='images/'.TNewFilelist_MenuTypes::getimage('download');
  	$exp_link->proparray['class'] = 'menuLink1';
  	$link1 = "download".$this->G_phpextension."?filepath=".urlencode($_GET['filepath']);
  	$exp_link->href = $link1;
    $this->fileoptionsarray[]=$exp_link;

  	$dwn_link =  new TLabelImageLink('Rename');
  	$dwn_link->caption = 'Rename';
  	$dwn_link->src='images/'.TNewFilelist_MenuTypes::getimage('rename');
  	$dwn_link->proparray['class'] = 'menuLink1';
  	$link1 =  "rename_file".$this->G_phpextension."?filepath=".urlencode($_GET['filepath']);
  	$dwn_link->href = $link1;
    if ($this->security_layer->useroptioncheck($_SESSION['fdrive'],'renamefile')){
    	$this->fileoptionsarray[]=$dwn_link;
    }

  	$ren_link =  new TLabelImageLink('Delete');
  	$ren_link->caption = 'Delete';
  	$ren_link->src='images/'.TNewFilelist_MenuTypes::getimage('delete');
  	$ren_link->proparray['class'] = 'menuLink1';
  	$link1 =  "delete".$this->G_phpextension."?filepath=".urlencode($_GET['filepath']);
  	$ren_link->href = $link1;
    if ($this->security_layer->useroptioncheck($_SESSION['fdrive'],'delfile')){
    	$this->fileoptionsarray[]=$ren_link;
    }

  	$weblink =  new TLabelImageLink('weblink');
  	$weblink->caption = 'Email link';
  	$weblink->src='images/'.TNewFilelist_MenuTypes::getimage('email');
  	$weblink->proparray['class'] = 'menuLink1';
  	$link1 =  "weblink".$this->G_phpextension."?filepath=".urlencode($_GET['filepath']);
  	$weblink->href = $link1;
  	$this->fileoptionsarray[]=$weblink;

    $this->dopluginwork();
    $icount=1;
    foreach($this->fileoptionsarray as $value){
   	  $linktable->addtocell($icount.'cell1' , $value);
   	  $icount++;
    }

  	$linktable->rows = $icount;
  	$linktable->cols = 1;
    $linktable->tdproparray['align']='left';
  	$fodlertable->addtocell('4cell1' , $linktable);

  	$fodlertable->addtocell('5cell1' , $this->btn_cancel);

  	$fodlertable->rows = 5;
  	$fodlertable->cols = 1;
    $fodlertable->tdproparray['align']='left';

 	  $this->headertable->addtocell('2cell1' , $fodlertable);

  }

  function file_cancel($sender,$foldername)
  {
    $this->javascript->script.= " javascript:window.location.href='ftme".$this->G_phpextension."?drive=".$_SESSION['fdrive']."&path=".urlencode($_SESSION['fpath'])."' ";
  }

}

?>
