<?
class Gregphoto_Service_Yahoo_Stocks {
	
	// symbols from http://www.gummy-stuff.org/Yahoo-data.htm
	public static $possible_symbols = array(
		'a' => 'Ask', 'a2' => 'Average Daily Volume', 'a5' => 'Ask Size', 'b' => 'Bid',
		'b2' => 'Ask (Real-time)', 'b3' => 'Bid (Real-time)', 'b4' => 'Book Value',
		'b6' => 'Bid Size', 'c' => 'Change & Percent Change', 'c1' => 'Change',
		'c3' => 'Commission', 'c6' => 'Change (Real-time)', 'c8' => 'After Hours Change (Real-time)',
		'd' => 'Dividend per Share', 'd1' => 'Last Trade Date', 'd2' => 'Trade Date',
		'e' => 'Earnings per Share', 'e1' => 'Error Indication',
		'e7' => 'EPS Estimate Current Year', 'e8' => 'EPS Estimate Next Year',
		'e9' => 'EPS Estimate Next Quarter', 'f6' => 'Float Shares', 'g' => 'Day Low',
		'g1' => 'Holdings Gain Percent', 'g3' => 'Annualized Gain', 'g4' => 'Holdings Gain',
		'g5' => 'Holdings Gain Percent (Real-time)', 'g6' => 'Holdings Gain (Real-time)',
		'h' => 'Day High', 'i' => 'More Info', 'i5' => 'Order Book (Real-time)',
		'j' => '52-week Low', 'j1' => 'Market Capitalization', 'j3' => 'Market Capitalization (Real-time)',
		'j4' => 'EBITDA', 'j5' => 'Change From 52-week Low', 'j6' => 'Percent Change From 52-week Low',
		'k' => '52-week High', 'k1' => 'Last Trade with Time (Real-time)', 'k2' => 'Change Percent (Real-time)',
		'k3' => 'Last Trade Size', 'k4' => 'Change From 52-week High', 'k5' => 'Percent Change From 52-week High',
		'l' => 'Last Trade with Time', 'l1' => 'Last Trade Price', 'l2' => 'High Limit',
		'l3' => 'Low Limit', 'm' => 'Day Range', 'm2' => 'Day Range (Real-time)',
		'm3' => '50-day Moving Average', 'm4' => '200-day Moving Average',
		'm5' => 'Change From 200-day Moving Average', 'm6' => 'Percent Change From 200-day Moving Average',
		'm7' => 'Change From 50-day Moving Average', 'm8' => 'Percent Change From 50-day Moving Average',
		'n' => 'Name', 'n4' => 'Notes', 'o' => 'Open', 'p' => 'Previous Close', 'p1' => 'Price Paid',
		'p2' => 'Change in Percent', 'p5' => 'Price/Sales', 'p6' => 'Price/Book', 'q' => 'Ex-Dividend Date',
		'r' => 'P/E Ratio', 'r1' => 'Dividend Pay Date', 'r2' => 'P/E Ratio (Real-time)',
		'r5' => 'PEG Ratio', 'r6' => 'Price/EPS Estimate Current Year', 'r7' => 'Price/EPS Estimate Next Year',
		's' => 'Symbol', 's1' => 'Shares Owned', 's7' => 'Short Ratio', 't1' => 'Last Trade Time',
		't6' => 'Trade Links', 't7' => 'Ticker Trend', 't8' => '1 yr Target Price', 'v' => 'Volume',
		'v1' => 'Holdings Value', 'v7' => 'Holdings Value (Real-time)', 'w' => '52-week Range',
		'w1' => 'Day Value Change', 'w4' => 'Day Value Change (Real-time)',
		'x' => 'Stock Exchange', 'y' => 'Dividend Yield');
	private $stocks = array();
	private $symbols = array('s','n','l1','d1','t1','c1');
	private $cacheLimit = 300;
	private $cacheDir = 'cache/';
	private $cacheObj;
	private $yahoo_base_url = 'http://quote.yahoo.com/d/quotes.csv?s=';

	public function __construct() {

	}

	public function addStocks($stocks) {
		if(is_string($stocks)) {
			$stocks = array($stocks);
		}
		foreach($stocks as $stock) {
			$this->stocks[] = trim($stock);
		}
	}

	// symbols from http://www.gummy-stuff.org/Yahoo-data.htm
	public function setSymbols($symbols) {
		if(!is_array($symbols)) {
			throw new Exception("Symbols must be an array");
		}
		$this->symbols = array();
		foreach($symbols as $symbol) {
			$symbol = trim($symbol);
			if(!array_key_exists($symbol,self::$possible_symbols)) {
				throw new Exception("$symbol is not a vaild symbol");
			}
			$this->symbols[] = $symbol;
		}
	}

	public function getStockInfo() {
		if(!is_object($this->cacheObj)) {
			$this->getCacheObj();
		}
		$cache = $this->cacheObj;
		$url = $this->generateYahooURL();
		$id = md5($url);
		if (!($cache->test($id))) {
			$stockArray = $this->getStockArray($url);
			$cache->save($stockArray);
		} else {
			$stockArray = $cache->get($id);
		}
		return new Gregphoto_Service_Yahoo_Stocks_ResultSet($stockArray);
	}

	private function getStockArray($url) {
		$http = new Zend_Http_Client($url);
		$response = $http->get();
		if($response->isSuccessful()) {
			require_once(dirname(__FILE__).'/csvstream.php');
			$stockArray = array();
			$GLOBALS['Gregphoto_Yahoo_Stocks_Stream'] = $response->getBody();
			$fp = fopen("csvstr://Gregphoto_Yahoo_Stocks_Stream", "r+");
			while (($row = fgetcsv($fp, 2000, ",")) !== FALSE) {
				$stockArray[] = array_combine($this->symbols,$row);
			}
			unset($GLOBALS['Gregphoto_Yahoo_Stocks_Stream']);
			return $stockArray;
		} else {
			throw new Exception("Unable to get data from Yahoo Finance");
		}
	}

	private function getCacheObj() {
		$frontendOptions = array('lifeTime' => $this->cacheLimit, 'automaticSerialization' => true);
		$backendOptions = array('cacheDir' => $this->cacheDir);
		$this->cacheObj = Zend_Cache::factory('Core', 'File', $frontendOptions, $backendOptions);
		$this->cacheObj;
	}

	private function generateYahooURL() {
		$url = $this->yahoo_base_url;
		$url .= implode('+',$this->stocks);
		$url .= '&f=' . implode('',$this->symbols);
		return $url;
	}
	
	public function setCacheDir($dir) {
		$this->cacheDir = $dir;
	}
	
	public function setCacheLimit($seconds) {
		$this->cacheLimit = $seconds;
	}
}
?>