<?php
class Gregphoto_Service_Yahoo_Stocks_ResultSet implements SeekableIterator {
	private $stockDataArray;
	private $_currentItem = 0;
	
	public function __construct($stockDataArray) {
		$this->stockDataArray = $stockDataArray;
	}
	
	public function totalResults() {
		return (int) count($this->stockDataArray);
	}

	public function getArray() {
		return $this->stockDataArray;
	}
	
	public function current() {
		return new Gregphoto_Service_Yahoo_Stocks_Result($this->stockDataArray[$this->_currentItem]);
	}

	public function key() {
		return $this->_currentItem;
	}

	public function next() {
		$this->_currentItem += 1;
	}

	public function rewind() {
		$this->_currentItem = 0;
		return true;
	}

	public function seek($item) {
		if ($this->valid($item)) {
			$this->_currentItem = $item;
			return $this->current();
		} else {
			throw new Exception('Index Out of Bounds');
		}
	}

	public function valid($item = null) {
		if (is_null($item) && $this->_currentItem < $this->totalResults()) {
			return true;
		} elseif (!is_null($item) && $item < $this->totalResults()) {
			return true;
		} else {
			return false;
		}
	}
}
